--[[
	Bongos PvP
		battleground/arena bar
--]]

local L = LibStub('AceLocale-3.0'):GetLocale('Bongos3-PvP')
local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local PvP = Bongos:GetModule('PvP')
local BG = Bongos:NewModule('BG')


--[[ Startup ]]--

function BG:Load()
	local defaults = {
		point = 'TOP',
		x = -5,
		y = -15,
	}
	
	self.bar, isNew = PvP:CreateBar('bg', defaults, nil, 'MEDIUM')
	if isNew then
		self.LoadBar(self.bar)
	end
end

function BG:Unload()
	self.bar:Destroy()
end

function BG:LoadBar()	
	local frame = WorldStateAlwaysUpFrame
 	frame:ClearAllPoints()
	frame:SetPoint('TOPLEFT', self, 'TOPLEFT', 45, 8)
	
	for k,v in pairs(BG) do self[k] = v end
	self.frame = frame
	self:Attach(frame)
end


--[[ Size Update ]]--

function BG:UpdateSize()
	local numFrames = NUM_ALWAYS_UP_UI_FRAMES
	local height, width = 0,0
	
	if numFrames > 0 then
		height = (self.sets.horizontal or numFrames) * 24 + 5
	
		for i = 1, numFrames do
			local frame = _G["AlwaysUpFrame" .. i]
			frame:ClearAllPoints()
			
			if not self.sets.horizontal then
				frame:SetPoint("TOP", - 23,  (- i + 1) * 24 - 20)
				width = max(self:GetFrameWidth("AlwaysUpFrame" .. i), width)
			else
				frame:SetPoint("Left", width - 45 + i * 5, - 25)
				width = width + self:GetFrameWidth("AlwaysUpFrame" .. i) + 5
			end
		end
	else
		if Bongos:IsLocked() then
			height, width = 0.1, 0.1
		else
			height = (self.sets.horizontal or 2) * 24 + 5
			width = (self.sets.horizontal or 0.5) * 144
		end
	end
	
	self:SetHeight(height)
	self:SetWidth(width)
end

function BG:GetFrameWidth(frame)
	local v = _G[frame .. "Text"]:GetWidth()
	return v + self:GetIconWidth(frame .. 'Icon') + self:GetIconWidth(frame .. 'DynamicIconButton')
end

function BG:GetIconWidth(icon)
	return _G[icon]:IsShown() and _G[icon]:GetWidth() or 0
end


--[[ Menu ]]--

function BG:CreateMenu()
	local menu = Bongos.Menu:Create(self.id)
	local panel = menu:AddLayoutPanel()
	
	local horizontal = panel:CreateCheckButton(L.Horizontal)
	horizontal:SetScript('OnShow', function() this:SetChecked(self.sets.horizontal) end)
	horizontal:SetScript('OnClick', function()
		self.sets.horizontal = this:GetChecked() and 1
		self:UpdateSize()
	end)
	
	return menu
end